package org.teiid.ws.jaxws.examples.generated;

import java.net.URL;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;



public class PortfolioTestClient {

	public static void main(String[] args) {
		try {
			
			URL wsdlLocation = new URL("http://localhost:8080/PortfolioView/MarketDataView_stock?wsdl"); //$NON-NLS-1$
	
			ObjectFactory of = new ObjectFactory();
			StockInputType stockInputType = of.createStockInputType();
			stockInputType.setSymbol(of.createStockInputTypeSymbol("RHT")); //$NON-NLS-1$
			
			PortfolioView portfolioView = new PortfolioView(wsdlLocation);
			MarketDataViewStock marketDataViewStock = (MarketDataViewStock)portfolioView.getPort(MarketDataViewStock.class);
			StockOutput stockOutput = (StockOutput)marketDataViewStock.getstock(stockInputType);

			for (StockOutputType out: stockOutput.getStockOutputInstance()){ 
				System.out.println("The current price for " + out.symbol.getValue() + " is " + NumberFormat.getCurrencyInstance().format(out.price.getValue()));  //$NON-NLS-1$ //$NON-NLS-2$
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}

}
